% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GLAM_1d_covariates.R
\name{GLAM_1d_covariates}
\alias{GLAM_1d_covariates}
\title{Fit the 1d GLAM with covariates}
\usage{
GLAM_1d_covariates(
  R,
  Y,
  Bs,
  Z = Z,
  Wprior = NULL,
  P,
  control_algorithm = list(maxiter = 20, conv_crit = 1e-05, verbose = FALSE)
)
}
\arguments{
\item{R}{A 2d-array of dimensions ns by n containing exposure times.}

\item{Y}{A 2d-array of dimensions ns by n containing event indicators.}

\item{Bs}{A matrix of B-splines for the \code{s} time scale of dimension ns by cs.}

\item{Z}{A regression matrix of covariates values of dimensions n by p.}

\item{Wprior}{An optional vector of length ns of a-priori weights.}

\item{P}{The penalty matrix of dimension cs by cs.}

\item{control_algorithm}{A list with optional values for the parameters of
iterative processes:
*\code{maxiter} The maximum number of iterations for the IWSL algorithm,
default is 20 .
* \code{conv_crit} The convergence criteria, expressed as difference between
estimates at iteration i and i+1, default is \code{1e-5}.
* \code{verbose} A Boolean. Default is \code{FALSE}. If \code{TRUE}, monitor the
iteration process.}
}
\value{
A list with the following elements:
\itemize{
\item \code{alpha} The vector of estimated P-splines coefficients of length cs.
\item \code{SE_alpha} The vector of estimated Standard Errors for the \code{alpha} coefficients,
of length cs.
\item \code{beta} The vector of length p of estimated covariates coefficients.
\item \code{se_beta} The vector of length p of estimated Standard Errors for the \code{beta}
coefficients.
\item \code{eta0} The vector of values of the baseline linear predictor (log-hazard).
\item \code{H} The hat-matrix.
\item \code{Cov} The full variance-covariance matrix.
\item \code{deviance} The deviance.
\item \code{ed} The effective dimension of the model.
\item \code{aic} The value of the AIC.
\item \code{bic} The value of the BIC.
\item \code{Bbases} a list with the B-spline basis \code{Bs} (this is a list for
compatibility with functions in 2d).
}
}
\description{
\code{GLAM_1d_covariates()} fits a GLAM for the hazard with one time
scale, with covariates.
}
