% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getAIC_BIC_LMM.R
\name{getAIC_BIC_LMM}
\alias{getAIC_BIC_LMM}
\title{Calculates AIC and BIC from object fitted via LMMsolver}
\usage{
getAIC_BIC_LMM(fit, offset)
}
\arguments{
\item{fit}{An object of class \code{"LMMsolve"}}

\item{offset}{The vector of exposure times from dataLMM}
}
\value{
A list with:
* \code{ED} effective dimension of the full model;
* \code{EDbase} effective dimension of the baseline hazard only;
* \code{Dev} deviance;
* \code{AIC} the aic;
* \code{BIC} the bic;
* \code{n_beta} the number of estimated covariate parameters (if PH model).
}
\description{
\code{getAIC_BIC_LMM} is an utility function that takes an object of class
\code{'LMMsolve'} fitted via \code{fit1ts()} or \code{fit2ts()} and calculates
AIC, BIC and ED.
}
