% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iwls_1d.R
\name{iwls_1d}
\alias{iwls_1d}
\title{Iterative Weighted Least Squares algorithm for 1ts model}
\usage{
iwls_1d(
  r,
  y,
  Bs,
  P,
  Wprior = NULL,
  control_algorithm = list(maxiter = 20, conv_crit = 1e-05, verbose = FALSE)
)
}
\arguments{
\item{r}{A vector of exposure times of length ns.}

\item{y}{A vector of event counts of length ns.}

\item{Bs}{A matrix of B-splines for the \code{s} time scale of dimension ns by cs.}

\item{P}{The penalty matrix of dimension cs by cs.}

\item{Wprior}{An optional vector of length ns of a-priori weights.}

\item{control_algorithm}{A list with optional values for the parameters of
the iterative processes:
\itemize{
\item \code{maxiter} The maximum number of iteration for the IWSL algorithm.
Default is 20.
\item \code{conv_crit} The convergence criteria, expressed as difference between
estimates at iteration i and i+1. Default is \code{1e-5}.
\item \code{verbose} A Boolean. Default is \code{FALSE}. If \code{TRUE} monitors the iteration
process.
}}
}
\value{
A list with the following elements:
\itemize{
\item \code{alpha} The vector of estimated P-splines coefficients of length cs.
\item \code{SE_alpha} The vector of estimated Standard Errors for the \code{alpha} coefficients,
of length cs.
\item \code{H} The hat-matrix.
\item \code{Cov} The full variance-covariance matrix.
\item \code{deviance} The deviance.
\item \code{ed} The effective dimension of the model.
\item \code{aic} The value of the AIC.
\item \code{bic} The value of the BIC.
\item \code{Bbases} a list with the B-spline basis \code{Bs} (this is a list for
compatibility with functions in 2d).
}
}
\description{
\code{iwls_1d()} fits the 1ts model with IWLS algorithm.
}
