% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/percentile.R
\name{percentile}
\alias{percentile}
\title{Percentile Function}
\usage{
percentile(x = NULL, p = NULL, learn = FALSE, interactive = FALSE)
}
\arguments{
\item{x}{Optional numeric vector (not needed for interactive mode)}

\item{p}{Numeric value between 0 and 1 for percentile calculation (not needed for interactive mode)}

\item{learn}{Logical, if TRUE shows step-by-step explanation}

\item{interactive}{Logical, if TRUE enables interactive practice mode}
}
\value{
The percentile value (for non-interactive mode)
}
\description{
This function calculates the percentiles of a numeric vector.
}
\examples{
data <- c(1,4,3,3,2,5,7,12)

# Simple calculation
percentile(data, 0.3)

percentile(data, 0.3, learn = TRUE)

if(interactive()){
percentile(interactive = TRUE)
}

}
