% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UEI.R
\name{UEI}
\alias{UEI}
\title{Uniform Error Index}
\usage{
UEI(actual, predicted)
}
\arguments{
\item{actual}{Univariate Data Series}

\item{predicted}{Predicted Data Series from Models}
}
\value{
\itemize{
\item ErrorSeries: Uniform Error Index Series
\item ErrorMetrics: Values of Different Error Measures i.e.,Relative Absolute Error (RAE),Mean Absolute Error(MAE),Median Absolute Error (MDAE),Mean Absolute Percent Error (MAPE),Root Mean Squared Error (RMSE),Mean Squared Error (MSE),Symmetric Mean Absolute Percentage Error(SMAPE), Sum of Squared Errors (SSE),Mean Uniform Error Index (MUEI).
}
}
\description{
Uniform Error Index
}
\examples{
library("UEI")
actual<- as.ts(rnorm(50,100,50))
predicted<- as.ts(rnorm(50,110,60))
Result <- UEI(actual, predicted)
}
\references{
\itemize{
\item Yeasin, M. and Paul, R.K., 2024. OptiSembleForecasting: optimization-based ensemble forecasting using MCS algorithm and PCA-based error index. The Journal of Supercomputing, 80(2), pp.1568-1597.
}
}
