% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/USP.test.R
\name{USP.test}
\alias{USP.test}
\title{Independence test for discrete data}
\usage{
USP.test(freq, B = 999, ties.method = "standard", nullstats = FALSE)
}
\arguments{
\item{freq}{Two-way contingency table whose independence is to be tested.}

\item{B}{The number of resampled null tables to be used to calibrate the test.}

\item{ties.method}{If "standard" then calculate the p-value as in (5) of \insertCite{BKS2020}{USP},
which is slightly conservative. If "random" then break ties randomly. This preserves Type I error
control.}

\item{nullstats}{If TRUE, returns a vector of the null statistic values.}
}
\value{
Returns the p-value for this independence test and the value of the test statistic, \eqn{T_n},
as defined in \insertCite{BKS2020}{USP}. The third element of the list is the table of expected counts,
and the final element is the table of contributions to \eqn{T_n}. If nullstats=TRUE is used, then the function also
returns a vector of the null statistics.
}
\description{
Carry out a permutation independence test on a two-way contingency table.
The test statistic is \eqn{Tn}, as described in Sections 3.1 and 7.1 of \insertCite{BKS2020}{USP}.
This also appears as \eqn{Un} in \insertCite{BS2021}{USP}.
The critical value is found by sampling null contingency tables,
with the same row and column totals as the input, via Patefield's algorithm, and recomputing
the test statistic.
}
\examples{
freq=r2dtable(1,rep(10,5),rep(10,5))[[1]] + 4*diag(rep(1,5))
USP.test(freq,999)

freq=diag(1:5); USP.test(freq,999)

freq=r2dtable(1,rep(10,5),rep(10,5))[[1]];
test=USP.test(freq,999,nullstats=TRUE)
plot(density(test$NullStats,from=0,
to=max(max(test$NullStats),test$TestStat)),
    xlim=c(min(test$NullStats),max(max(test$NullStats),test$TestStat)),
    main="Test Statistics")
abline(v=test$TestStat,col=2); TestStats=c(test$TestStat,test$NullStats)
abline(v=quantile(TestStats,probs=0.95),lty=2)
}
\references{
\insertRef{BKS2020}{USP}

\insertRef{BS2021}{USP}
}
