% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UD_ANOVA_model.R
\name{UD_ANOVA_model}
\alias{UD_ANOVA_model}
\title{Model-wise uncertainty based on the second order interaction ANOVA}
\usage{
UD_ANOVA_model(data, var_name, stages = setdiff(names(data), var_name))
}
\arguments{
\item{data}{a data frame containing models(factor or character) for each stages and the variable of interest(numeric).
data should contain all combinations of models.}

\item{var_name}{the name of the variable of interest}

\item{stages}{names of the stages of interest.}
}
\value{
List(UD_model class) including uncertainties of models, uncertainties from main effects, uncertainties from interaction, total uncertainty, names of stages and models
}
\description{
This function performs uncertainty decomposition by model based on the second order interaction ANOVA model.
The uncertainty from interaction effect from two models is divided equally and assigned to each model.
}
\examples{
set.seed(0)
stage1 <- LETTERS[1:3]
stage2 <- LETTERS[1:2]
stage3 <- LETTERS[1:4]
y <- rnorm(3*2*4)
data <- expand.grid(stage1=stage1,
                    stage2=stage2,
                    stage3=stage3)
stages <- names(data)
data <- cbind(data, y)

UD_ANOVA_model <- UD_ANOVA_model(data, "y", stages)
UD_ANOVA_model
UD_ANOVA_stage <- UD_model2stage(UD_ANOVA_model)
UD_ANOVA_stage
}
