# modified.chisq.test.R
#
# Author: Xuye Luo, Joe Song
# 
# Updated:
#
# December 20, 2025
#   Updated documentation
#
# December 11, 2025

#' @title Zero-Tolerant Pearson's Chi-squared Statistic
#'
#' @inherit modified.chisq.test details
#' @inherit modified.chisq.test note

#' @description Calculates Pearson's chi-squared test statistic for contingency tables, 
#'   ignoring entries with zero-expected count. 
#'
#' @param x a matrix or data frame of floating or integer
#'  numbers to specify a contingency table. Entries
#'  must be non-negative.
#'
#' @return The numeric value of the modified Pearson's chi-squared test statistic.
#'
#' @references
#' \insertRef{luo2021upsilon}{Upsilon}
#' @importFrom Rcpp sourceCpp
#' @useDynLib Upsilon, .registration=TRUE
#' @export
#'
#' @examples
#' library("Upsilon")
#' 
#' # Create a table with empty rows or columns
#' x <- matrix(c(0, 3, 0, 3, 0, 0), nrow = 2, byrow = TRUE)
#' print(x)
#' 
#' # Standard chisq.test might warn or fail on a table with empty rows or columns
#' chisq.test(x) 
#' 
#' # Modified statistic handles it gracefully
#' modified.chisq.statistic(x)
#' @keywords internal
modified.chisq.statistic <- function(x) {
  # Ensure input is a matrix
  x <- as.matrix(x)
  
  if (!is.numeric(x)) {
    stop("Input 'x' must be a numeric matrix or table.")
  }
  
  # Call C++ backend
  statistic <- modified_chisq_statistic_cpp(x)
  
  return(statistic)
}