% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_selective_inference.R
\name{merge_selective_inference}
\alias{merge_selective_inference}
\title{Merged version of the selective test}
\usage{
merge_selective_inference(X, k1, k2, g, ndraws = 2000, cl_fun, cl)
}
\arguments{
\item{X}{The data matrix of size on which the clustering is applied}

\item{k1}{The first cluster of interest}

\item{k2}{The second cluster of interest}

\item{g}{The variables for which the test is applied}

\item{ndraws}{The number of Monte-Carlo samples}

\item{cl_fun}{The clustering function used to build clusters}

\item{cl}{The labels of the data obtained thanks to the \code{cl_fun} function}
}
\value{
A list with the following elements \itemize{
\item \code{pval} : The resulting p-values of the test.
\item \code{adjacent} : List of the adjacent clusters between k1 and k2
\item \code{pval_adj} : The corresponding adjacent p-values that are merged
}
}
\description{
Merged version of the selective test
}
\examples{
X <- matrix(rnorm(200),ncol = 2)
hcl_fun <- function(x){
return(as.factor(cutree(hclust(dist(x), method = "ward.D2"), k=4)))}
cl <- hcl_fun(X)
plot(X, col=cl)
#Note that in practice the value of ndraws (the number of Monte-Carlo simulations must be higher)
test_var1 <- test_selective_inference(X, k1=1, k2=4, g=1, ndraws =100, cl_fun = hcl_fun, cl = cl)
}
