% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dlCvrt.R
\name{dl2arr}
\alias{dl2arr}
\title{Convert a double list to array}
\usage{
dl2arr(x)
}
\arguments{
\item{x}{A double list to be converted.}
}
\value{
Return an array filled with the binding character elements.
}
\description{
Convert a double list to an array. The pure numeric layers will be sorted intrinsically then all
elements will be bound in certain order as one character element, and filled into the proper location in the array.
}
\examples{
#Make column names of datatest into double list:
dl <- chrvec2dl(colnames(datatest), "-")

#Convert the double list to a tensor:
dl2arr(dl)
}
\seealso{
\code{\link[VBTree:dl2vbt]{dl2vbt}}, \code{\link[VBTree:dl2ts]{dl2ts}}.
}
\keyword{Double.List}
\keyword{array}
