% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_forecast_report.R
\name{generate_forecast_report}
\alias{generate_forecast_report}
\title{Generate Viral Respiratory Forecast Report}
\usage{
generate_forecast_report(
  input_data_dir = NULL,
  output_dir = NULL,
  n_days = 7,
  validate_window_size = 7,
  smooth = FALSE,
  disease_season = NULL
)
}
\arguments{
\item{input_data_dir}{Path to input CSV data. Must contain columns: \code{date}, \code{confirm}, \code{disease_type}.
Allowed values for \code{disease_type}: \code{"flu_a"}, \code{"flu_b"}, \code{"rsv"}, \code{"sars_cov2"}, \code{"custom"}.}

\item{output_dir}{Path to output directory for the rendered HTML report.}

\item{n_days}{Number of days ahead to forecast. Default is 7.}

\item{validate_window_size}{The number of days between each validation window. Default is 7.}

\item{smooth}{Logical indicating whether smoothing should be applied in the forecast. Default is \code{TRUE}.}

\item{disease_season}{An optional named list specifying the seasonal date
ranges for each disease. Each element should be either:
\itemize{
\item NULL (indicating no defined season), or
\item a two-date vector in "YY-MM-DD" format (e.g., c("2024-09-01", "2025-03-01")) defining
the start and end of the season for that disease.
}

For example:
disease_season = list(
flu_a     = c("2024-09-01", "2025-03-01"),
rsv       = c("2024-09-01", "2025-03-01"),
sars_cov2 = NULL
)

This will produce a report where influenza A and RSV seasons run from
September 1, 2024 to March 1, 2025, while no season is defined for SARS-CoV-2.}
}
\value{
Invisibly returns the path to the rendered HTML report.
}
\description{
Generates a full-season forecast report for viral respiratory diseases as an HTML document.
}
\examples{
\donttest{
data <- simulate_data(start_date = "2024-01-07", #starting Sunday
)
diseases <- c("flu_a", "rsv", "sars_cov2")
data$date <- lubridate::ymd(data$date)
vri_data_list <- purrr::set_names( purrr::map2( rep(list(data), length(diseases)),
                                  diseases,
                                  ~ get_aggregated_data(.x, "date", .y)
                                 ),
                            diseases
)
# Save the simulated data
df <- purrr::imap_dfr(
vri_data_list,
\(df, disease) dplyr::mutate(df, disease_type = disease)
)
tmp_dir <- tempdir() # temporary directory for example for saving data
data_path <- file.path(tmp_dir, "simulated_data.csv")
write.csv(df, data_path, row.names = FALSE)

output_path <- tempdir() # output directory for report (temporary as example)
generate_forecast_report(input_data_dir = data_path,
                         output_dir = output_path,
                         n_days = 7,
                         validate_window_size = 7,
                         smooth = FALSE)
}
}
