% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{gen_z}
\alias{gen_z}
\title{Calculate z-score for Confidence Interval Overlap}
\usage{
gen_z(b, v, alpha = 0.05, df = Inf, ...)
}
\arguments{
\item{b}{A vector of estiamtes}

\item{v}{The variance-covariance matrix for \code{b}.}

\item{alpha}{The desired probability at which the confidence intervals do not overlap under the null hypothesis.}

\item{df}{Degrees of freedom for the t-distribution, defaults to \code{Inf} indicating a normal distribution.}

\item{...}{Other arguments passed down, currently not implemented.}
}
\value{
A list with two elements:
\code{ave_z}: A data frame with one row for each estimate in \code{b} and the following variables:
\itemize{
\item \code{vij}: observation number
\item \code{s_zb}: standard deviation of the z-scores across all pairs of intervals containing that estimate.
\item \code{min_zb}, \code{max_zb}: The minimum and maximum z-scores for the pairs of intervals containing that estimate.
\item \code{zb}: The mean z-score for the pairs of intervals containing that estimate.
\item \code{ci}: The confidence level corresponding to \code{zb}.
\code{all_z}: A data frame with one row for each pair of estimates in \code{b} and the following variables:
\item \code{i}, \code{j}: The indices of the two estimates in the pair.
\item \code{s_i}, \code{s_j}: The standard errors of the two estimates in the pair.
\item \code{theta}: The ratio of the standard errors of the two estimates.
\item \code{rho}: The correlation between the two estimates.
\item \code{zb}: The z-score for the pair of estimates.
\item \code{ci} : The confidence level corresponding to \code{zb}.
\item \code{olap_ave} The probability that the two intervals do not overlap under the null hypothesis.
\item \code{olap_84} The probability that two 84\% confidence intervals for the estimates in the pair would not overlap under the null hypothesis.
}
}
\description{
Calculates the z-score required such that confidence intervals do not overlap under the null hypothesis withe a specified probability.
}
\examples{
data(mtcars)
mod <- lm(mpg ~ wt + hp + disp + vs, data=mtcars)
gen_z(coef(mod), vcov(mod))

}
\references{
Harvey Goldstein and Michael J.R. Healy.  (1995) "The Graphical Presentation of A Collection of Means." Journal of the Royal Statistical Society, Series A 158(1): 175-177 \url{doi:10.2307/2983411}.
David Afshartous and Richard A. Preston.  (2010) "Confidence Intervals for Dependent Data: Equating Non-overlap with Statistical Significance." Computational Statistics and Data Analysis 54: 2296-2305 \url{doi:10.1016/j.csda.2010.04.011}
}
