% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crown_metrics.R
\name{tree_metrics}
\alias{tree_metrics}
\title{Estimates a set of morphological parameters from a tls point cloud of a tree.}
\usage{
tree_metrics(
  data,
  dbh,
  height,
  crown_diameter,
  crown_proj_area,
  volume,
  message
)
}
\arguments{
\item{data}{a data.frame or data.table containing the x, y, z, ... coordinates of a point cloud.}

\item{dbh}{numeric and optional. Estimate tree DBH ?}

\item{height}{numeric and optional. Estimate tree height ?}

\item{crown_diameter}{numeric and optional. Estimate tree average crown diameter ?}

\item{crown_proj_area}{numeric and optional. Estimate tree crown projected area ?}

\item{volume}{numeric and optional. Estimate tree volume ?}

\item{message}{logical. If FALSE, messages are disabled. Default = TRUE.}
}
\value{
a list containing the estimated value for each parameter.
}
\description{
Estimates a set of morphological parameters from a tls point cloud of a tree.
}
\details{
\subsection{Selecting parameters to compute}{If none of \code{dbh},\code{height},\code{crown_diameter},
            \code{crown_proj_area} and \code{volume} are passed, all parameters are computed. However, the
            user can select a set of parameters by declaring wich parameters should be computed (all other are not).}
\subsection{Parameters estimates}{The tree DBH is estimated as the diameter of a circle fitted to the point cloud between
            1.2m and 1.4m above the ground. The tree height is computed as the elevation difference between the lowest and
            the highest points of the point cloud. Two values are provided for crown parameter. First a 2D convex hull
            is used to identify the external points of the crown. Then, a first estimate of the crown diameter ("distant_points")
            is computed as the average distance of each point to the further point. A second estimate ("circle_fitting") correspond
            to the diameter of a circle fitted to the crown external points. The crown projected area is computed as the area of a
            2D convex hull that wraps the projected crown. The volume is computed as the volume of a 3D convex hull that wraps the point cloud.}
}
\examples{
#- import tls data
tls=data.table::fread(system.file("extdata", "Tree_t0.asc", package="VoxR"))

#- compute all metrics
VoxR::tree_metrics(tls)

#- compute DBH only
VoxR::tree_metrics(tls,dbh = TRUE)

#- compute DBH and height
VoxR::tree_metrics(tls,dbh = TRUE,height = TRUE)
}
