% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logging.R
\name{W4MLogger}
\alias{W4MLogger}
\title{The W4MLogger Class}
\arguments{
\item{name}{character vector of length 1 - The name of the logger.
Use different loggers with a name specific to each part of you program.
The name will appear in the log prefix and helps to determine which
part of the program did what}

\item{format}{character vector of length 1 - The format string for each
log line. The default is :
\code{"[{{ level }}-{{ name }}-{{ time }}] - {{ message }}"}}

\item{do_coloring}{logical vector of length 1 - By default, the logger
uses special control character to give some coloring to the text,
depending on the log level (info, warning, error, debug or verbose).
This coloring is deactivated in files and if
\code{W4MRUtils::in_galaxy_env()} returns TRUE. You can force or
deactivate the coloring with this  parameter.}

\item{show_debug}{logical vector of length 1 - Tells whether the
debug logs must be displayed/written or not. Default is FALSE}

\item{show_verbose}{logical vector of length 1 - Tells whether the
verbose logs must be displayed/written or not. Default is FALSE}

\item{show_info}{logical vector of length 1 - Tells whether the
info logs must be displayed/written or not Default is TRUE.}

\item{show_warning}{logical vector of length 1 - Tells whether the
warning logs must be displayed/written or not Default is TRUE.}

\item{show_error}{logical vector of length 1 - Tells whether the
error logs must be displayed/written or not Default is TRUE.}

\item{coloring}{named list - This lists maps a logging level to
its coloring. Like this: \code{list(debug = "purple", info = "green")}
Available colors can be found in \code{W4MRUtils::w4m_colors__}.}

\item{out_func}{function - the default function to print messages
in the terminal. The default is \code{base::message} .}

\item{out_path}{list of file paths - Provide a list of file path
where the logs will be written. It is not possible to separate
different levels of logs in different log files for the moment.}
}
\value{
A W4MLogger instance
}
\description{
This is a simple logger used to make uniform outputs across W4M tools.

See \link{get_logger} for example usages.
}
\seealso{
\link{W4MLogger$info}, \link{W4MLogger$warning}, \link{W4MLogger$error},
\link{W4MLogger$debug}, \link{W4MLogger$verbose}
}
\author{
L.Pavot
}
