% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/warEst.R
\name{getInnovation}
\alias{getInnovation}
\title{Calculating innovations in WAR(p) models}
\usage{
getInnovation(quantile, quantile.grid, p)
}
\arguments{
\item{quantile}{A matrix containing all the available quantile functions. Columns represent time indices and rows represent evaluation grid.}

\item{quantile.grid}{A numeric vector, the grid over which quantile functions are evaluated.}

\item{p}{A positive integer, the order of the fitted WAR(p) model.}
}
\value{
A list with
\itemize{
  \item innovation - The tangent space innovations evaluated over the quantile grid.  Fitting a WAR(p) model for \eqn{n} observations will produce \eqn{n-2p} innovations.
  \item cov.surf - The covariance surface
}
}
\description{
This function calculates innovations in WAR(p) models
}
\references{
\cite{Wasserstein Autoregressive Models for Density Time Series, Chao Zhang, Piotr Kokoszka, Alexander Petersen, 2022}
}
\keyword{internal}
