% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WPL0.R
\name{WPL0}
\alias{WPL0}
\title{p-Wasserstein projections with an L0 penalty}
\usage{
WPL0(
  X,
  Y = NULL,
  theta,
  power = 2,
  method = c("selection.variable", "projection"),
  transport.method = transport_options(),
  epsilon = 0.05,
  OTmaxit = 0,
  parallel = NULL,
  ...
)
}
\arguments{
\item{X}{matrix of covariates}

\item{Y}{matrix of predictions}

\item{theta}{optional matrix of coefficients from original model, if relevant}

\item{power}{power of the Wasserstein distance}

\item{method}{One of "selection.variable" or "projection". Methods decide whether covariate matrix in \code{theta} is preserved ("selection.variable") or if new projections are generated ("projection")}

\item{transport.method}{Method for Wasserstein distance calculation. Should be one of the outputs of \code{\link[=transport_options]{transport_options()}}.}

\item{epsilon}{hyperparameter for sinkhorn iterations}

\item{OTmaxit}{max iteration for sinkhorn iterations}

\item{parallel}{foreach backend}
}
\value{
\code{WpProj} object
}
\description{
p-Wasserstein projections with an L0 penalty
}
\keyword{internal}
