% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fleshler_hoffman.r
\name{fleshler_hoffman}
\alias{fleshler_hoffman}
\title{Fleshler & Hoffman (1962) progression}
\usage{
fleshler_hoffman(N, VI)
}
\arguments{
\item{N}{The total number of intervals.}

\item{VI}{The value of the Variable Interval}
}
\value{
A vector of calculated values for the intervals.
}
\description{
This function calculates the values of intervals approximately for
an exponential distribution, but avoiding extremely large values.
}
\details{
This function calculates the values of intervals approximately for
a exponential distribution, but avoiding extremely large values which can
produce extinction.
It uses the formula derived from the Fleshler & Hoffman article, where the
first factor of the equation is -log(1 - p)^(-1), representing the expected
value or mean of the intervals. This value is also the inverse of a Poisson
process, 1/lambda. Since we want the expected value or mean to be the value
of the IV, we replace that constant with VI.
The function handles the case when n = N, where the value becomes undefined
(log(0)), by using L'Hopital's rule to find the limit of the function as n
approaches N. The resulting values are then multiplied by the IV and the
logarithm of N to obtain the final calculated values.
}
\examples{
# Calculate intervals for N = 10, and IV = 30
N <- 15
iv <- 90
intervals <- round(fleshler_hoffman(N,iv), 3)
# Plot the intervals and the exponential distribution corresponding to the
# same mean (IV)
hist(intervals, freq = FALSE)
curve(dexp(x, rate = 1/iv), add = TRUE, col = 'red')
legend('topright', legend = c('F&H', 'Exponential'), lty = 1, col = c('black', 'red'))
}
\references{
Fleshler, M., & Hoffman, H. S. (1962). A progression for generating variable-interval schedules.
Journal of the Experimental Analysis of Behavior, 5(4), 529-530.
}
