% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simul_zinarp.R
\name{simul_zinarp}
\alias{simul_zinarp}
\title{Sample Generator for ZINAR(p)}
\usage{
simul_zinarp(n, alpha, lambda, pii = 0)
}
\arguments{
\item{n}{The length of the simulated chain.}

\item{alpha}{The p-dimensional vector (in which p is the process order) of alpha values, the probabilities of an element remaining in the process.All alpha elements must be in [0,1] and their sum must be smaller than 1.}

\item{lambda}{The Poisson rate parameter. Must be greater than zero.}

\item{pii}{The probability of a structural zero (i.e., ignoring the Poisson distribution) under ZIP innovation sequences. Defaults to 0, following a standard Poisson.}
}
\value{
Returns a numeric vector representing a realization of an INAR/ZINAR(p) process.
}
\description{
This function generates a realization of a ZINAR(p) process.
}
\references{
Garay, Aldo M., Francyelle L. Medina, Celso RB Cabral, and Tsung-I. Lin. "Bayesian analysis of the p-order integer-valued AR process with zero-inflated Poisson innovations." Journal of Statistical Computation and Simulation 90, no. 11 (2020): 1943-1964.

Garay, Aldo M. ; Medina, Francyelle L. ; Jales, Isaac C. ; Bertail, Patrice. First-order integer valued AR processes with zero-inflated innovations. Cyclostationarity: Theory and Methods, Springer Verlag - 2021, v. 1, p. 19-40.
}
