% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SVM.R
\name{SVM}
\alias{SVM}
\title{Generate SVM decision boundaries for positive and negative control separation.}
\usage{
SVM(ECdataList)
}
\arguments{
\item{ECdataList}{A list containing event coverage data from the EventCoverage() function. The list should contain:
\itemize{
  \item EC_N_D: Event coverage matrix for negative controls in decrease direction
  \item EC_P_D: Event coverage matrix for positive controls in decrease direction
  \item EC_N_I: Event coverage matrix for negative controls in increase direction
  \item EC_P_I: Event coverage matrix for positive controls in increase direction
  \item ZseqList: Z-score thresholds for both directions
}}
}
\value{
A list containing two data frames:
  \item{cutOffD}{A data frame with SVM decision boundary points for decrease direction. Each row contains a Z-score threshold and the corresponding event coverage threshold that separates positive and negative controls.}
  \item{cutOffI}{A data frame with SVM decision boundary points for increase direction. Each row contains a Z-score threshold and the corresponding event coverage threshold that separates positive and negative controls.}
}
\description{
This function constructs Support Vector Machine (SVM) models to find optimal decision boundaries that separate positive and negative control samples in event coverage space. It uses radial kernel SVM to create non-linear decision boundaries for both decrease and increase directions.
}
\details{
The function performs the following steps:
\enumerate{
  \item Prepares training data by combining positive and negative control event coverage data
  \item Trains separate SVM models for decrease and increase directions using radial kernel
  \item Uses pre-tuned hyperparameters (cost=20, gamma=3 for decrease; cost=50, gamma=2 for increase)
  \item Generates prediction grids across the Z-score and event coverage space
  \item Identifies decision boundary points where the SVM prediction changes from negative to positive
  \item Returns the optimal threshold points for each Z-score bin
}

The resulting SVM curves can be used for background correction in zeta score calculations to improve the accuracy of hit identification.
}
\examples{
data(countMat)
data(negGene)
data(posGene)
ZscoreVal <- Zscore(countMat, negGene)
ECdataList <- EventCoverage(ZscoreVal, negGene, posGene, binNum=10, combine=TRUE)
\donttest{SVM(ECdataList)}

}
\author{
Yajing Hao, Shuyang Zhang, Junhui Li, Guofeng Zhao, Xiang-Dong Fu
}
\keyword{SVM}
\keyword{ZetaSuite}
\keyword{boundary}
\keyword{decision}
\keyword{machine}
\keyword{support}
\keyword{vector}
