% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-slope_selector.R
\name{check_slope_rule_overlap}
\alias{check_slope_rule_overlap}
\title{Check overlap between existing and new slope rulesets}
\usage{
check_slope_rule_overlap(existing, new, slope_groups, .keep = FALSE)
}
\arguments{
\item{existing}{Data frame with existing selections and exclusions.}

\item{new}{Data frame with new rule to be added or removed.}

\item{slope_groups}{List with column names that define the groups.}

\item{.keep}{Whether to force keep fully overlapping rulesets. If FALSE, it will be assumed
that the user wants to remove rule if new range already exists in the dataset.
If TRUE, in that case full range will be kept.}
}
\value{
Data frame with full ruleset, adjusted for new rules.
}
\description{
Takes in tables with existing and incoming selections and exclusions, finds any overlap and
differences, edits the ruleset table accordingly.
}
