% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_components.R
\name{bray_curtis_components}
\alias{bray_curtis_components}
\alias{bray_curtis_balanced}
\alias{bray_curtis_gradient}
\alias{ruzicka_balanced}
\alias{ruzicka_gradient}
\title{Balanced variation and abundance gradient components for abundance data}
\usage{
bray_curtis_balanced(x, y)

bray_curtis_gradient(x, y)

ruzicka_balanced(x, y)

ruzicka_gradient(x, y)
}
\arguments{
\item{x, y}{Numeric vectors}
}
\value{
The balanced variation or abundance gradient component of distance
  between \code{x} and \code{y}. This quantity is undefined when either
  \code{x} or \code{y} have all elements equal to zero, in which case we
  return \code{NaN}.
}
\description{
Balanced variation and abundance gradient components for abundance data
}
\references{
Baselga A. Separating the two components of abundance-based dissimilarity:
balanced changes in abundance vs.abundance gradients. Methods in Ecology
and Evolution. 2013;4:552–557.

Baselga A. Partitioning abundance-based multiple-site dissimilarity into
components: balanced variation in abundance and abundance gradients.
Methods in Ecology and Evolution. 2017;8:799–808.
}
