% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abe.R
\name{print.abe}
\alias{print.abe}
\title{Print Function}
\usage{
\method{print}{abe}(
  x,
  type = c("coefficients", "coefficients reporting", "models"),
  models.n = NULL,
  conf.level = 0.95,
  alpha = NULL,
  tau = NULL,
  digits = 3,
  ...
)
}
\arguments{
\item{x}{an object of class `"abe"`, an object returned by a call to [abe.resampling()]}

\item{type}{the type of the output. `type = "coefficients"` prints summary statistics for each coefficient, `type = "coefficients reporting"` prints a reduced version of the coefficient statistics, and `type = "models"` reports model selection frequencies.}

\item{models.n}{controls the number of models printed if `type = "models"`. See details.}

\item{conf.level}{the confidence level, defaults to 0.95, see `details`}

\item{alpha}{the alpha value for which the output is to be printed, defaults to `NULL`}

\item{tau}{the tau value for which the output is to be printed, defaults to `NULL`}

\item{digits}{integer, indicating the number of digits to display in the table. Defaults to 2}

\item{...}{additional arguments affecting the summary produced.}
}
\description{
Prints a summary table of a bootstrapped/resampled version of ABE.
The table displays the relative inclusion frequencies of the covariates from the initial model,
the coefficient estimates and standard errors from the initial model (model with all covariates), the selected model,
resampled median and percentiles for the estimates of the regression coefficients for each variable from the initial model,
root mean squared difference ratio (RMSD) and relative bias conditional on selection (RBCS), see `details`.
}
\details{
When using `type.resampling="Wallisch2021"` in a call to [abe.resampling()], the results for the relative inclusion frequencies of the covariates from the initial model are based on subsampling with sampling proportion equal to 0.5 and the other results are based on bootstrap as suggested by Wallisch et al. (2021); otherwise all the results are obtained by using the method as specified in `type.resampling`.
Parameter `conf.level` defines the lower and upper quantile of the bootstrapped/resampled distribution such that equal proportion of values are smaller and larger than the lower and the upper quantile, respectively.

If `type = "models"`, the `models.n` parameter controls the number of models printed. One option is to directly specify the number of models to return (i.e. an integer larger than 1). Alternatively, if `models.n` is set to a number less than (or equal to) 1, the number of models returned is such that the cumulative frequency attains that value. By default (`models.n = NULL`), the top 20 models or all models up to a cumulative frequency of 0.8, whichever is shorter, are returned. The selected model is marked with an asterisk. If it is not among the printed models, it is added as the last model.
}
\examples{
set.seed(100)
n = 100
x1 <- runif(n)
x2 <- runif(n)
x3 <- runif(n)
y<- -5 + 5 * x1 + 5 * x2 + rnorm(n, sd = 5)
dd <- data.frame(y = y,x1 = x1, x2 = x2, x3 = x3)
fit <- lm(y ~ x1 + x2 + x3, x = TRUE, y = TRUE, data= dd)

fit.resample <- abe.resampling(fit, data = dd, include = "x1", active = "x2",
tau = c(0.05, 0.1), exact = TRUE, criterion = "alpha", alpha = c(0.2, 0.05),
type.test = "Chisq", num.resamples = 50, type.resampling = "Wallisch2021")

print(fit.resample, conf.level = 0.95, alpha = 0.2, tau = 0.05)
}
\references{
Wallisch C, Dunkler D, Rauch G, de Bin R, Heinze G. Selection of variables for multivariable models: Opportunities and limitations in quantifying model stability by resampling. Statistics in Medicine 40:369-381, 2021.
}
\seealso{
\link{abe.resampling}, \link{summary.abe}, \link{plot.abe}, \link{pie.abe}
}
\author{
Rok Blagus, \email{rok.blagus@mf.uni-lj.si}

Sladana Babic

Daniela Dunkler

Gregor Steiner
}
