#' COVID-19 Spread and School Policy Effects Data
#'
#' A balanced panel data set analyzing the impact of K-12 school openings and other policy measures on the spread of COVID-19 across U.S. counties. The data spans 32 weeks from April 1st to December 2nd, 2020, and covers 2510 counties.
#'
#' @format A data frame with 80320 (2510 counties times 32 weeks) rows and 9 columns.
#' Each column represents a variable:
#' \describe{
#'   \item{fips}{County FIPS}
#'   \item{week}{Week}
#'   \item{school}{A measure of visits to K-12 schools from SafeGraph foot traffic data}
#'   \item{logdc}{Logarithm of the number of reported COVID-19 cases}
#'   \item{pmask}{Policy indicators on mask mandates}
#'   \item{pgather50}{Policy indicators on ban on gatherings of more than 50 persons}
#'   \item{college}{Measure of visits to colleges}
#'   \item{pshelter}{Policy indicators on stay-at-home orders}
#'   \item{dlogtests}{A measure of the weekly growth rate in the number of tests}
#' }
#' @source Data initially provided by Victor Chernozhukov, Hiroyuki Kasahara, and Paul Schrimpf on the GitHub repository \url{https://github.com/ubcecon/covid-schools}.
#' Counties with missing values are dropped to obtain a balanced panel dataset.
#'
#' @examples
#' data(covid_data) # Access the dataset
"covid_data"
