% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_all_tweets.R
\name{get_all_tweets}
\alias{get_all_tweets}
\title{Get tweets from full archive search}
\usage{
get_all_tweets(
  query = NULL,
  start_tweets,
  end_tweets,
  bearer_token = get_bearer(),
  n = 100,
  file = NULL,
  data_path = NULL,
  export_query = TRUE,
  bind_tweets = TRUE,
  page_n = 500,
  context_annotations = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{query}{string or character vector, search query or queries}

\item{start_tweets}{string, starting date}

\item{end_tweets}{string, ending date}

\item{bearer_token}{string, bearer token}

\item{n}{integer, upper limit of tweets to be fetched}

\item{file}{string, name of the resulting RDS file}

\item{data_path}{string, if supplied, fetched data can be saved to the designated path as jsons}

\item{export_query}{If \code{TRUE}, queries are exported to data_path}

\item{bind_tweets}{If \code{TRUE}, tweets captured are bound into a data.frame for assignment}

\item{page_n}{integer, amount of tweets to be returned by per page}

\item{context_annotations}{If \code{TRUE}, context_annotations will be fetched. Note it will limit the page_n to 100 due restrictions of Twitter API.}

\item{verbose}{If \code{FALSE}, query progress messages are suppressed}

\item{...}{arguments will be passed to \code{\link[=build_query]{build_query()}} function. See \code{?build_query()} for further information.}
}
\value{
When bind_tweets is \code{TRUE} (default), the function returns a data frame. Nothing otherwise.
}
\description{
This function collects tweets by query string or strings
between specified date ranges.
}
\details{
The function can also collect tweets by users. These may be specified alongside
a query string or without. When no query string is supplied, the function collects
all tweets by that user.

If a filename is supplied, the function will
save the result as a RDS file.

If a data path is supplied, the function will also return
tweet-level data in a data/ path as a series of JSONs beginning "data_";
while user-level data will be returned as a series of JSONs beginning "users_".
}
\examples{
\dontrun{
bearer_token <- "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"

get_all_tweets(query = "BLM", 
               start_tweets = "2020-01-01T00:00:00Z", 
               end_tweets = "2020-01-05T00:00:00Z", 
               bearer_token = get_bearer(), 
               data_path = "data",
               n = 500)
  
get_all_tweets(users = c("cbarrie", "jack"),
               start_tweets = "2021-01-01T00:00:00Z", 
               end_tweets = "2021-06-01T00:00:00Z",
               bearer_token = get_bearer(), 
               n = 1000)
                            
get_all_tweets(start_tweets = "2021-01-01T00:00:00Z", 
               end_tweets = "2021-06-01T00:00:00Z",
               bearer_token = get_bearer(), 
               n = 1500, 
               conversation_id = "1392887366507970561")
}
}
