% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_user_id.R
\name{get_user_id}
\alias{get_user_id}
\title{Get user id}
\usage{
get_user_id(
  usernames,
  bearer_token = get_bearer(),
  all = FALSE,
  keep_na = TRUE
)
}
\arguments{
\item{usernames}{character vector containing screen names to be queried}

\item{bearer_token}{string, bearer token}

\item{all}{logical, default FALSE to get a character vector of user IDs. Set it to TRUE to get a data frame, see below}

\item{keep_na}{logical, default TRUE to keep usernames that cannot be queried. Set it to TRUE to exclude those usernames. Only useful when all is FALSE}
}
\value{
a string vector with the id of each of the users unless all = TRUE. If all = TRUE, a data.frame with ids, names (showed on the screen) and usernames is returned.
}
\description{
This function get the user IDs (e.g. 1349149096909668363) of given usernames, e.g. "potus".
}
\examples{
\dontrun{
bearer_token <- "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
users <- c("Twitter", "TwitterDev")
get_user_id(users, bearer_token)
}
}
