% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accrual_linear_model.R
\name{accrual_linear_model}
\alias{accrual_linear_model}
\title{accrual_linear_model}
\usage{
accrual_linear_model(
  accrual_df,
  fill_up = TRUE,
  wfun = function(x) seq(1/nrow(x), 1, by = 1/nrow(x))
)
}
\arguments{
\item{accrual_df}{object of class 'accrual_df' or 'accrual_list' produced by \code{accrual_create_df}.}

\item{fill_up}{whether to fill up days where no recruitment was observed,}

\item{wfun}{function to calculate the weights with accrual data frame as argument,
default is wfun<-function(x) seq(1 / nrow(x), 1, by = 1/nrow(x)).}
}
\value{
Returns an object of class 'lm' with a weighted linear regression of cumulative accrual on dates.
}
\description{
Creates a weighted linear regression model using an accrual data frame produced by \code{accrual_create_df}.
}
\examples{
\donttest{
data(accrualdemo)
accrual_df<-accrual_create_df(accrualdemo$date)
accrual_linear_model(accrual_df)

#unweighted
accrual_linear_model(accrual_df, wfun=function(x) rep(1,nrow(x)))

#different start and current date
accrual_df<-accrual_create_df(accrualdemo$date,start_date=as.Date("2020-07-08"),
    current_date=as.Date("2020-07-15"))
accrual_linear_model(accrual_df)

#accrual_df with by option
accrual_df<-accrual_create_df(accrualdemo$date,by=accrualdemo$site)
accrual_linear_model(accrual_df)
}
}
