% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotRatios}
\alias{plotRatios}
\title{Plot global/group residency}
\usage{
plotRatios(
  input,
  groups,
  sections,
  type = c("absolutes", "percentages"),
  title,
  xlab,
  ylab,
  col,
  col.by = c("default", "section", "group")
)
}
\arguments{
\item{input}{The results of an actel analysis (either explore, migration or residency).}

\item{groups}{An optional argument to plot only the data corresponding to some groups.}

\item{sections}{An optional argument to plot the residency of the multiple groups for a specific subset of sections.}

\item{type}{The type of residency to be displayed. One of 'absolutes' (the default) or 'percentages'.}

\item{title}{An optional title for the plot. If left empty, a default title will be added.}

\item{xlab, ylab}{Optional axis names for the plot. If left empty, default axis names will be added.}

\item{col}{An optional colour scheme for the detections. If left empty, default colours will be added.}

\item{col.by}{Colour scheme to use. One of 'section' or 'group'. By default, plots are coloured by section if all
sections are displayed, and by group if only a subset of the sections is required using the argument \code{sections}.}
}
\value{
A ggplot object.
}
\description{
By default, this function plots the global residency. However, you can use the argument 'group'
to plot the results only from a specific animal group. Lastly, you can also use 'sections', rather
than 'group', to compare the residency at a specific section (or group of sections) between the
different groups.
}
\details{
The output of plotRatios is a ggplot object, which means you can then use it in combination
with other ggplot functions, or even together with other packages such as patchwork.
}
\examples{
# For this example, I have modified the example.results that come with actel,
# so they resemble a residency output
\dontshow{
example.residency.results <- c(example.results, additional.residency.results)
example.residency.results$rsp.info$analysis.type <- "residency"
}
plotRatios(example.residency.results)

# Because plotRatios returns a ggplot object, you can store
# it and edit it manually, e.g.:
library(ggplot2)
p <- plotRatios(example.residency.results, groups = "A")
p <- p + xlab("changed the x axis label a posteriori")
p

# You can also save the plot using ggsave!

}
