% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/actfts-package.R
\docType{package}
\name{actfts-package}
\alias{actfts}
\alias{actfts-package}
\title{actfts: Autocorrelation Tools Featured for Time Series}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

The 'actfts' package provides tools for performing autocorrelation analysis of time series data. It includes functions to compute and visualize the autocorrelation function (ACF) and the partial autocorrelation function (PACF). Additionally, it performs the Dickey-Fuller, KPSS, and Phillips-Perron unit root tests to assess the stationarity of time series. Theoretical foundations are based on Box and Cox (1964) \doi{10.1111/j.2517-6161.1964.tb00553.x}, Box and Jenkins (1976) <isbn:978-0-8162-1234-2>, and Box and Pierce (1970) \doi{10.1080/01621459.1970.10481180}. Statistical methods are also drawn from Kolmogorov (1933) \doi{10.1007/BF00993594}, Kwiatkowski et al. (1992) \doi{10.1016/0304-4076(92)90104-Y}, and Ljung and Box (1978) \doi{10.1093/biomet/65.2.297}. The package integrates functions from 'forecast' (Hyndman & Khandakar, 2008) \url{https://CRAN.R-project.org/package=forecast}, 'tseries' (Trapletti & Hornik, 2020) \url{https://CRAN.R-project.org/package=tseries}, 'xts' (Ryan & Ulrich, 2020) \url{https://CRAN.R-project.org/package=xts}, and 'stats' (R Core Team, 2023) \url{https://stat.ethz.ch/R-manual/R-devel/library/stats/html/00Index.html}. Additionally, it provides visualization tools via 'plotly' (Sievert, 2020) \url{https://CRAN.R-project.org/package=plotly} and 'reactable' (Glaz, 2023) \url{https://CRAN.R-project.org/package=reactable}. The package also incorporates macroeconomic datasets from the U.S. Bureau of Economic Analysis: Disposable Personal Income (DPI) \url{https://fred.stlouisfed.org/series/DPI}, Gross Domestic Product (GDP) \url{https://fred.stlouisfed.org/series/GDP}, and Personal Consumption Expenditures (PCEC) \url{https://fred.stlouisfed.org/series/PCEC}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/SergioFinances/actfts}
  \item \url{https://sergiofinances.github.io/actfts/}
  \item Report bugs at \url{https://github.com/SergioFinances/actfts/issues}
}

}
\author{
\strong{Maintainer}: Sergio Sierra \email{sergiochess95@gmail.com} (\href{https://orcid.org/0000-0003-4055-8810}{ORCID})

Authors:
\itemize{
  \item David Rodríguez \email{davestss@hotmail.com} (\href{https://orcid.org/0000-0001-5430-0787}{ORCID}) [copyright holder]
}

}
\keyword{internal}
