% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/counts.R
\name{counts}
\alias{counts}
\title{counts}
\usage{
counts(
  data,
  hertz = -1,
  x_axis = 2,
  y_axis = 3,
  z_axis = 4,
  time_column = -1,
  start_time = -1
)
}
\arguments{
\item{data}{Accelerometer data, Must have at least three columns.}

\item{hertz}{Sampling frequency in Hz}

\item{x_axis}{Indicates the column number which has the accel data for x direction, the default is 2}

\item{y_axis}{Indicates the column number which has the accel data for y direction, the default is 3}

\item{z_axis}{Indicates the column number which has the accel data for z direction, the default is 4}

\item{time_column}{Optional. Indicates the column number which has the date and time.
The first row will be considered as the start time of the study. You can use the
"start_time" argument to provide the start time explicitly.}

\item{start_time}{Optional. Use this to define the start time of the experiment.
You can use this argument if the data does not contain a time column.}
}
\value{
Returns a \code{data.table} with four columns: \describe{
\item{Time}{The start time of the measurement}
\item{x}{the number of counts for X axis}
\item{y}{the number of counts for Y axis}
\item{z}{the number of counts for Z axis}
}
}
\description{
Calculates ActiLife counts based on raw accelerometer data
}
\examples{
# for tha sampleXYZ dataset, sampling frequency is 100 Hz
counts(data = sampleXYZ, hertz = 100)

# when start time is given explicitly
study_start_time <- "2017-08-22 12:30:10"
counts(data = sampleXYZ, hertz = 100 , start_time = study_start_time)

# the data has a time column, which is the first column
counts(data = sampleXYZ, hertz = 100 , time_column = 1)

# explicitly specify the X, Y and Z axis columns.
counts(data = sampleXYZ, hertz = 100 , x_axis = 2,y_axis = 3, z_axis = 4)



}
\seealso{
\link{sampleXYZ}
 raw accelerometer data for testing \code{counts()} function.

 \link{sampleCounts}
 counts calculated by a\code{ctivityCounts} and ActiLife
}
