% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjIntercept.R
\name{adjustIntercept}
\alias{adjustIntercept}
\title{Adjust the intercept to regain the balance property}
\usage{
adjustIntercept(obj, data)
}
\arguments{
\item{obj}{an object of type \code{\link{glm}}, \code{\link[cplm]{cpglm}} or \code{\link[cplm]{cpglmm}}
containing the model fit.}

\item{data}{a \code{\link{data.frame}} or \code{\link[data.table]{data.table}} object that was used to fit the model.}
}
\value{
The object with the adjusted (fixed effects) coefficients.
}
\description{
This function updates the intercept term of the model fit such that the balance property is satisfied.
}
\examples{
library(statmod)
datas  = dataCar[1:1e3, ]
Fit    = glm(Y ~ area + gender, data = datas, weights = datas$w, family = tweedie(1.75, 0),
model = TRUE, control = glm.control(epsilon = 1e-4, maxit = 5e2))
w      = weights(Fit, "prior")
y      = Fit$y
sum(w * y) == sum(w * fitted(Fit))
adjFit = adjustIntercept(Fit, datas)
coef(adjFit)
sum(w * y) == sum(w * fitted(adjFit))
}
\references{
Campo, B.D.C. and Antonio, Katrien (2023). Insurance pricing with hierarchically structured data an illustration with a workers' compensation insurance portfolio. \emph{Scandinavian Actuarial Journal}, doi: 10.1080/03461238.2022.2161413

Wüthrich, M. V. (2020). Bias regularization in neural network models for general insurance pricing. \emph{European actuarial journal} \bold{10}(1), 179–202.
}
