% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step_expose.R
\name{step_expose}
\alias{step_expose}
\title{Create exposure records in a \code{recipes} step}
\usage{
step_expose(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  end_date,
  start_date = as.Date("1900-01-01"),
  target_status = NULL,
  options = list(cal_expo = FALSE, expo_length = "year"),
  drop_pol_num = TRUE,
  skip = TRUE,
  id = recipes::rand_id("expose")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the sequence of
operations for this recipe.}

\item{...}{One or more selector functions to choose variables for this step.
See \code{\link[recipes:selections]{selections()}} for more details.}

\item{role}{Not used by this step since no new variables are created.}

\item{trained}{A logical to indicate if the quantities for preprocessing have
been estimated.}

\item{end_date}{Experience study end date}

\item{start_date}{Experience study start date. Default value = 1900-01-01.}

\item{target_status}{Character vector of target status values. Default value
= \code{NULL}.}

\item{options}{A named list of additional arguments passed to \code{\link[=expose]{expose()}}.}

\item{drop_pol_num}{Whether the \code{pol_num} column produced by \code{\link[=expose]{expose()}}
should be dropped. Defaults to \code{TRUE}.}

\item{skip}{A logical. Should the step be skipped when the recipe is baked by
\code{\link[recipes:bake]{bake()}}? While all operations are baked when \code{\link[recipes:prep]{prep()}} is run, some
operations may not be able to be conducted on new data (e.g. processing the
outcome variable(s)). Care should be taken when using \code{skip = TRUE} as it
may affect the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new expose step added to the
sequence of any existing operations. For the \code{tidy} method, a \code{tibble} with
the columns \code{exposure_type}, \code{target_status}, \code{start_date}, and \code{end_date}.
}
\description{
\code{step_expose()} creates a \emph{specification} of a recipe step that will convert
a data frame of census-level records to exposure-level records.
}
\details{
Policy year exposures are calculated as a default. To switch to calendar
exposures or another exposure length, use pass the appropriate arguments to
the \code{options} parameter.

Policy numbers are dropped as a default whenever the recipe is baked. This
is done to prevent unintentional errors when the model formula includes
all variables (\code{y ~ .}). If policy numbers are required for any reason
(mixed effect models, identification, etc.), set \code{drop_pol_num} to \code{FALSE}.
}
\examples{

expo_rec <- recipes::recipe(status ~ ., toy_census) |>
  step_expose(end_date = "2022-12-31", target_status = "Surrender",
              options = list(expo_length = "month")) |>
  prep()

recipes::juice(expo_rec)

}
\seealso{
\code{\link[=expose]{expose()}}
}
