% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_saved.R
\name{update_saved_calibration}
\alias{update_saved_calibration}
\title{Update previously saved calibration result}
\usage{
update_saved_calibration(path, version = NULL, compress = TRUE)
}
\arguments{
\item{path}{single character; the path to the saved
\code{"trial_calibration"}-object containing the calibration result saved by
\code{\link[=calibrate_trial]{calibrate_trial()}}.}

\item{version}{passed to \code{\link[=saveRDS]{saveRDS()}} when saving the updated object, defaults
to \code{NULL} (as in \code{\link[=saveRDS]{saveRDS()}}), which means that the current default version
is used.}

\item{compress}{passed to \code{\link[=saveRDS]{saveRDS()}} when saving the updated object,
defaults to \code{TRUE} (as in \code{\link[=saveRDS]{saveRDS()}}), see \code{\link[=saveRDS]{saveRDS()}} for other options.}
}
\value{
Invisibly returns the updated \code{"trial_calibration"}-object.
}
\description{
This function updates a previously saved \code{"trial_calibration"}-object created
and saved by \code{\link[=calibrate_trial]{calibrate_trial()}} using a previous version of \code{adaptr},
including the embedded trial specification and trial results objects
(internally using the \code{\link[=update_saved_trials]{update_saved_trials()}} function). This allows the
use of calibration results, including the calibrated trial specification and
the best simulations results from the calibration process, to be used without
errors by this version of the package. The function should be run only once
per saved simulation object and will issue a warning if the object is already
up to date. And overview of the changes made according to the \code{adaptr} package
version used to generate the original object is provided in \strong{Details}.\cr
}
\details{
The following changes are made according to the version of \code{adaptr} used to
generate the original \code{"trial_calibration"} object:
\itemize{
\item \verb{v1.3.0+}: updates version number of the
\code{"trial_calibration"}-object and updates the embedded
\code{"trial_results"}-object (saved in \verb{$best_sims}, if any) and
\code{"trial_spec"}-objects (saved in \verb{$input_trial_spec} and
\verb{$best_trial_spec}) as described in \code{\link[=update_saved_trials]{update_saved_trials()}}.
}
}
\seealso{
\code{\link[=run_trials]{run_trials()}}.
}
