% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adephylo-package.R
\docType{data}
\name{procella}
\alias{procella}
\title{Phylogeny and quantitative traits of birds}
\format{
\code{procella} is a list containing the 2 following objects:
\describe{ \item{tre}{is a character string giving the phylogenetic tree in
Newick format.} \item{traits}{is a data frame with 19 species and 6 traits}
}
}
\description{
This data set describes the phylogeny of 19 birds as reported by Bried et
al. (2002). It also gives 6 traits corresponding to these 19 species.
}
\details{
Variables of \code{procella$traits} are the following ones: \cr - site.fid:
a numeric vector that describes the percentage of site fidelity\cr -
mate.fid: a numeric vector that describes the percentage of mate fidelity\cr
- mass: an integer vector that describes the adult body weight (g)\cr - ALE:
a numeric vector that describes the adult life expectancy (years)\cr - BF: a
numeric vector that describes the breeding frequencies\cr - col.size: an
integer vector that describes the colony size (no nests monitored)
}
\note{
This dataset replaces the former version in ade4.
}
\examples{


if(require(ape) && require(phylobase)){

## load data, make tree and phylo4d object
data(procella)
tre <- read.tree(text=procella$tre)
x <- phylo4d(tre, procella$traits)
oldpar <- par(mar=rep(.1,4))
table.phylo4d(x,cex.lab=.7)
par(oldpar)
}


}
\references{
Bried, J., Pontier, D. and Jouventin, P. (2002) Mate fidelity in
monogamus birds: a re-examination of the Procellariiformes. \emph{Animal
Behaviour}, \bold{65}, 235--246.

See a data description at \url{http://pbil.univ-lyon1.fr/R/pdf/pps037.pdf}
(in French).
}
\keyword{datasets}
