% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitmap.R
\name{get_adf_bitmap}
\alias{get_adf_bitmap}
\title{Get virtual disks bitmap flags}
\usage{
get_adf_bitmap(dev, vol = 0L, ...)
}
\arguments{
\item{dev}{The virtual adf device for which information needs to be obtained.
It should be of class \code{adf_device} which can be created with \code{\link[=create_adf_device]{create_adf_device()}}
or \code{\link[=connect_adf]{connect_adf()}}.}

\item{vol}{Volume index number on the device starting at \code{0}. Default is \code{0}.
Note that floppy disks can only have 1 volume installed.}

\item{...}{Ignored}
}
\value{
Returns the bitmap table
as a \code{logical} \code{vector}. Each, element is named after its
referencing block number, the value indicates if the block
is reserved by the file system.
}
\description{
Amiga devices had  one (or more) blocks dedicated to
registering which blocks are used by the file system and
which are available to allocate. This block is called the
bitmap block. This function returns the bitmap table for
the specified volume.
}
\examples{
my_device <- demo_adf()

bitmap <- get_adf_bitmap(my_device)

## Show blocks used by the file system
bitmap[bitmap]

close(my_device)
}
