% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaps.R
\name{identify_gaps}
\alias{identify_gaps}
\title{Identify Gaps in Therapy}
\usage{
identify_gaps(.data)
}
\arguments{
\item{.data}{data frame}
}
\value{
A new claims tibble with an appended column, \code{gap}
}
\description{
Compute gaps in a patient's therapy from the end of their prior fill to the beginning of the next. This function assumes that one has
arranged the dates and grouped appropriately outside of the function. The length of any gap will be appended 
to the row after the gap has occurred.
}
\note{
This function relies an \code{adjusted_date} column to identify gaps in therapy. So, if you don't want to use \code{propagate_date()} beforehand,
you'll need to rename the date variable you wish to use to \code{adjusted_date}.
}
\examples{
library(adheRenceRX)
library(dplyr)

toy_claims \%>\% 
  filter(ID == "D") \%>\% 
  propagate_date(.date_var = date, .days_supply_var = days_supply) \%>\% 
  identify_gaps()


}
