% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eigenstrat.R
\name{filter_bed}
\alias{filter_bed}
\title{Filter EIGENSTRAT data based on a given BED file}
\usage{
filter_bed(
  data,
  bed,
  remove = FALSE,
  outfile = tempfile(fileext = ".snp"),
  bedtools_args = ""
)
}
\arguments{
\item{data}{EIGENSTRAT data object.}

\item{bed}{Path to a BED file.}

\item{remove}{Remove sites falling inside the BED file regions? By default,
sites that do not overlap BED regions are removed.}

\item{outfile}{Path to an output snp file with coordinates of excluded sites.}

\item{bedtools_args}{Optional arguments to `bedtools intersect` such as \code{"-sorted"}
or \code{"-sorted -nonamecheck"}.}
}
\value{
Updated S3 EIGENSTRAT data object.
}
\description{
Keep (or discard) SNPs that overlap (or lie outside of) regions in a given
BED file.
}
\details{
This function requires a functioning bedtools installation! See:

- https://github.com/arq5x/bedtools2

- https://bedtools.readthedocs.io/
}
\examples{
\dontrun{# download an example genomic data set
prefix <- download_data(dirname = tempdir())
# create an EIGENSTRAT R object from the downloaded data
snps <- eigenstrat(prefix)

# get the path to an example BED file
bed <- file.path(dirname(prefix), "regions.bed")

# BED file contains regions to keep in an analysis
snps_kept <- filter_bed(snps, bed)
# BED file contains regions to remove from an analysis
snps_removed <- filter_bed(snps, bed, remove = TRUE)
}

}
