% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plantedsubmatrix.R
\name{plantedsubmatrix}
\alias{plantedsubmatrix}
\title{Sample matrix}
\usage{
plantedsubmatrix(M, N, m, n, p, q)
}
\arguments{
\item{M}{number of rows in sampled matrix}

\item{N}{number of rows in sampled matrix}

\item{m}{number of rows in dense submatrix}

\item{n}{natural number used to calculate number of rows in dense submatrix}

\item{p}{density outside planted submatrix}

\item{q}{density inside planted submatrix}
}
\value{
Matrix \eqn{G} sampled from the planted dense \eqn{(mn)}-submatrix model, dense sumbatrix \eqn{X0}, matrix \eqn{Y0} used to count the number of disagreements between \eqn{G} and \eqn{X0}
}
\description{
Generates binary \eqn{(M,N)} - matrix sampled from dense \eqn{(m,n)} - submatrix.
}
\details{
Let \eqn{U*} and \eqn{V*} be \eqn{m} and \eqn{n} index sets.
For each i in U*, j in V* we let \eqn{a_ij = 1} with probability \eqn{q} and \eqn{0}  otherwise.
For each remaining \eqn{ij} we set \eqn{a_ij = 1} with probability \eqn{p < q} and take \eqn{a_ij = 0} otherwise.
}
\examples{
plantedsubmatrix(10,10,1,2,0.25,0.75)
}
