% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc_freundlichNLM.R
\name{mcmc_freundlichNLM}
\alias{mcmc_freundlichNLM}
\title{MCMC Analysis for Freundlich Isotherm Non-linear Model}
\arguments{
\item{Ce}{Numeric vector of equilibrium concentrations.}

\item{Qe}{Numeric vector of adsorbed amounts.}

\item{burnin}{Integer specifying the number of burn-in iterations (default is 1000).}

\item{mcmc}{Integer specifying the total number of MCMC iterations (default is 5000).}

\item{thin}{Integer specifying the thinning interval (default is 10).}

\item{verbose}{Integer controlling the frequency of progress updates (default is 100).}

\item{plot}{Logical; if TRUE, trace and density plots of the MCMC chains are shown (default is FALSE).}

\item{n_chains}{Number of independent MCMC chains (default = 2).}

\item{seed}{Optional integer for reproducibility.}
}
\value{
A list containing:
\describe{
  \item{Kf_mean}{Posterior mean estimate of Freundlich constant (Kf).}
  \item{n_mean}{Posterior mean estimate of Freundlich exponent (n).}
  \item{logKf_mean}{Posterior mean of (log(K_f)).}
  \item{inv_n_mean}{Posterior mean of (1/n).}
  \item{logKf_sd}{Posterior standard deviation for (log(Kf)).}
  \item{inv_n_sd}{Posterior standard deviation for (1/n).}
  \item{logKf_ci}{95\% credible interval for (log(Kf)).}
  \item{inv_n_ci}{95\% credible interval for (1/n).}
  \item{gelman_diag}{Gelman-Rubin diagnostics (only if multiple chains).}
  \item{mcmc_summary}{Summary statistics for each parameter.}
}
}
\description{
Performs Bayesian parameter estimation using Markov Chain Monte Carlo (MCMC)
for the non-linear Freundlich isotherm model:
Qe = Kf * Ce^(1/n)
This approach is applied to obtain a probabilistic distribution of the model parameters, capturing uncertainties
and potential correlations between them.
}
\examples{
Ce <- c(0.01353, 0.04648, 0.13239, 0.27714, 0.41600, 0.63607, 0.80435, 1.10327, 1.58223)
Qe <- c(0.03409, 0.06025, 0.10622, 0.12842, 0.15299, 0.15379, 0.15735, 0.15735, 0.16607)
mcmc_freundlichNLM(Ce, Qe, burnin = 1000, mcmc = 5000, thin = 10,
                   verbose = 100, plot = TRUE, n_chains = 2, seed = 123)
}
\references{
Gilks, W. R., Richardson, S., & Spiegelhalter, D. J. (1995). \emph{Markov Chain Monte Carlo in Practice}. Chapman and Hall/CRC.
}
\author{
Paul Angelo C. Manlapaz
}
