% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adw.R
\name{awa}
\alias{awa}
\title{Area weighted average.}
\usage{
awa(dat, lat)
}
\arguments{
\item{dat}{a numeric vector of grid data. The missing values are not allowed.}

\item{lat}{a latitude numeric vector of grid data. The cosine of latitude is
used as the weight coefficient.}
}
\value{
a scalar value, i.e the value of area weighted average.
}
\description{
The large area, or hemispheric, or global averages can be calculated
dependent on the area represented by the grid-point or grid-box. The weight of
latitude-longitude grid-points-boxes should be the cosine of the latitude of
the ith grid-point-box.
}
\examples{
# set.seed(2)
# dd <- data.frame(lon = runif(100, min = 110, max = 117),
#                  lat = runif(100, min = 31, max = 37),
#                  value = runif(100, min = -10, max = 10))
# grd <- points2grid(dd, extent = c(110, 117, 31, 37), gridsize = 0.5)
# grd <- na.omit(grd)
# awa(grd$value, grd$lat) # area weighted average
}
\references{
Jones, P. D., and M. Hulme, 1996: Calculating regional climatic time series for temperature and precipitation: Methods and illustrations. Int. J. Climatol., 16, 361–377, https://doi.org/10.1002/(SICI)1097-0088(199604)16:4<361::AID-JOC53>3.0.CO;2-F.
}
