% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ghg_flux.R
\name{convert_ghg_unit}
\alias{convert_ghg_unit}
\title{convert_ghg_unit}
\usage{
convert_ghg_unit(ghg_value, ghg, mass = "µmol", area = "m2", time = "h")
}
\arguments{
\item{ghg_value}{The value of the flux.}

\item{ghg}{The molecular formula of greenhouse gases (co2: carbon dioxide; ch4: methane; n2o: nitrous oxide).}

\item{mass}{The mass component of the input GHG flux, default to micromoles.}

\item{area}{The area component of the input GHG flux, default to square meter.}

\item{time}{The time component of the input GHG flux, default to hour.}
}
\value{
A numeric value.
}
\description{
Convert the greenhouse gas (GHG) flux to micromoles per square meter per hour.
}
\examples{
convert_ghg_unit(1, ghg = "co2")
}
