% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess_judgements.R
\name{preprocess_judgements}
\alias{preprocess_judgements}
\title{Pre-process the data}
\usage{
preprocess_judgements(
  expert_judgements,
  round_2_filter = TRUE,
  three_point_filter = TRUE,
  percent_toggle = FALSE
)
}
\arguments{
\item{expert_judgements}{A dataframe with the same variables (columns) as
\link{data_ratings}.}

\item{round_2_filter}{Note that the IDEA protocol results in both a Round 1
and Round 2 set of probabilities for each claim. Unless otherwise specified,
we will assume that the final Round 2 responses (after discussion) are being
referred to.}

\item{three_point_filter}{Defaults \code{TRUE} to filter three point estimates. \code{FALSE} will
filter the involved_binary question.}

\item{percent_toggle}{Change the values to probabilities from percentages. Default is \code{FALSE}}
}
\value{
a long tibble of expert judgements, with six columns:
\code{round}, \code{paper_id}, \code{user_name}, \code{element} (i.e. question type),
and \code{value} (i.e. participant response).
}
\description{
Process input data with filters and meaningful variable names.

This function is called at the head of every aggregation method function.
}
\details{
This pre-processing function takes input data in the format of
\link{data_ratings} and outputs a dataframe that:
\enumerate{
\item Applies any filters or manipulations required by the aggregation method.
\item Converts the input data into variables with more
meaningful names for coding, to avoid errors in the wrangling process.
}
}
\examples{
\donttest{preprocess_judgements(data_ratings)}

}
