% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alpNeeded2.R
\name{alpNeeded2}
\alias{alpNeeded2}
\title{Function to compute alpha needed (fixed sample size)}
\usage{
alpNeeded2(N, bta1, thta, L, pow = 0.8, ar = 0.5)
}
\arguments{
\item{N}{Sample size.}

\item{bta1}{log-transform of rate ratio.}

\item{thta}{Variance of frailty parameter.}

\item{L}{Number of events.}

\item{pow}{Target power.}

\item{ar}{Allocation ratio (Number control / Total).}
}
\value{
The two-sided alpha level.
}
\description{
Function to compute two-sided alpha needed to achieve target power given a rate ratio. Useful for computing probability to achieve hurdles.
}
\details{
This function computes the two-sided alpha alp.
Function assumes a rate ratio < 1 is favourable to treatment.
}
\examples{

# alpha needed to achieve multiple powers given rate ratio (and other input).
alpNeeded2(N = 1000, bta1 = log(0.8), thta = 2, L = 1000, pow = c( .7, .8))

# alpha needed for many inputs
if (require("dplyr") & require("tidyr")) {


}


}
