% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pow2.R
\name{pow2}
\alias{pow2}
\title{Power for LWYY (fixed sample size)}
\usage{
pow2(N, bta1, thta, L, alp = 0.05, ar = 0.5)
}
\arguments{
\item{N}{Sample size.}

\item{bta1}{log-transform of rate ratio.}

\item{thta}{Variance of frailty parameter.}

\item{L}{Number of events.}

\item{alp}{Two-sided alpha-level.}

\item{ar}{Allocation ratio (Number control / Total)}
}
\value{
The power given the input assumptions.
}
\description{
Function to compute power at one-sided Type I control level alp/2.
}
\examples{

pow2(N = 500, bta1 = log(0.8), thta = 2, L = 1000, alp = 0.05)
pow2(N = 500, bta1 = log(0.8), thta = 3, L = 1000, alp = 0.05)

if (require("dplyr") & require("tidyr")) {

  assumptions = tibble(alp = 0.05) \%>\%
  crossing(
    thta = c(1),
    RR = c(0.6, 0.7, 0.8),
    L = c(1000, 1500, 2000),
    N = c(500, 1000)
  ) \%>\%
    mutate(pow = pow2(N = N, bta1 = log(RR), thta = thta, L = L, alp = alp))

  assumptions \%>\% data.frame()

}

}
