% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{protective_layers}
\alias{protective_layers}
\title{Create Protective Layers for Design of Experiments (DOEs)}
\usage{
protective_layers(design, borders = c(0, 3, 5, 10))
}
\arguments{
\item{design}{An \code{sf} object containing the polygons of the experiment.
The coordinate reference system (crs) of the data needs to be in
metric distance, not degrees.}

\item{borders}{A numeric vector specifying the distances (in meters) for which
protective layers should be created. The layers will be created
with decreasing distances, starting from the largest.}
}
\value{
An \code{sf} object representing the protective layers around the
        experiment polygons.
}
\description{
This function generates protective layers around the polygons of an experiment.
These layers can be used to plot boundaries, for example, to protect agricultural
on-farm experiments from accidental harvesting.
}
\examples{
library(agricolaeplotr)
library(sf)
library(ggplot2)
example("make_polygons")
polygo <- make_polygons(plt, north = 13454206.89, east = 7939183.21)
polygo <- st_transform(polygo, 25832)
pl <- protective_layers(polygo)
# plot experiment shape
ggplot(pl) + geom_sf(fill=c("black","orange","blue","red"))+ theme_minimal()
# write them to kml for Google Maps
# st_write(pl, "boundaries2.kml", append = FALSE)

}
