% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ability_agreement.R
\name{table_agreement}
\alias{table_agreement}
\title{Table of Agreement}
\usage{
table_agreement(
  Y,
  D,
  Z,
  A,
  subgroup1,
  subgroup2,
  label.subgroup1 = "Subgroup 1",
  label.subgroup2 = "Subgroup 2"
)
}
\arguments{
\item{Y}{An observed outcome (binary: numeric vector of 0 or 1).}

\item{D}{An observed decision (binary: numeric vector of 0 or 1).}

\item{Z}{A treatment indicator (binary: numeric vector of 0 or 1).}

\item{A}{An AI recommendation (binary: numeric vector of 0 or 1).}

\item{subgroup1}{A pretreatment covariate used for subgroup analysis (vector).}

\item{subgroup2}{A pretreatment covariate used for subgroup analysis (vector).}

\item{label.subgroup1}{A label for subgroup1 (character). Default "Subgroup 1".}

\item{label.subgroup2}{A label for subgroup2 (character). Default "Subgroup 2".}
}
\value{
A tibble with the following columns:
\itemize{
  \item \code{cov}: Subgroup label.
  \item \code{X}: Subgroup value.
  \item \code{agree_diff}: Difference in agreement between human decisions and AI recommendations.
  \item \code{agree_diff_se}: Standard error of the difference in agreement.
  \item \code{ci_lb}: Lower bound of the 95\% confidence interval.
  \item \code{ci_ub}: Upper bound of the 95\% confidence interval.
}
}
\description{
Estimate the impact of AI recommendations on the agreement between human decisions and AI recommendations using a difference-in-means estimator of an indicator \eqn{1\{D_i = A_i\}}.
Generate a table based on the overall agreement and subgroup-specific agreement.
}
\examples{
table_agreement(
  Y = NCAdata$Y,
  D = ifelse(NCAdata$D == 0, 0, 1),
  Z = NCAdata$Z,
  A = PSAdata$DMF,
  subgroup1 = ifelse(NCAdata$White == 1, "White", "Non-white"),
  subgroup2 = ifelse(NCAdata$Sex == 1, "Male", "Female"),
  label.subgroup1 = "Race",
  label.subgroup2 = "Gender"
)

}
