% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/irt_model_continuous.R
\name{cirtmodel}
\alias{cirtmodel}
\title{Fits a continuous IRT model.}
\usage{
cirtmodel(df, max.item = NULL, min.item = NULL)
}
\arguments{
\item{df}{The performance data in a matrix or dataframe.}

\item{max.item}{A vector with the maximum performance value for each algorithm.}

\item{min.item}{A vector with the minimum performance value for each algorithm.}
}
\value{
A list with the following components:
\item{\code{model}}{The IRT model.  }
\item{\code{anomalous}}{A binary value for each algorithm. It is set to 1 if an algorithm is anomalous. Otherwise it is set to 0.  }
 \item{\code{consistency}}{The consistency of each algorithm.}
 \item{\code{difficulty_limit}}{The difficulty limit of each algorithm. A higher difficulty limit indicates that the algorithm can tackle harder problems.}
}
\description{
This function fits a continuous Item Response Theory (IRT) model to the algorithm performance data. The function EstCRMitem in the R package EstCRM is updated to accommodate negative discrimination.
}
\examples{
set.seed(1)
x1 <- runif(100)
x2 <- runif(100)
x3 <- runif(100)
X <- cbind.data.frame(x1, x2, x3)
mod <- cirtmodel(X)

}
\references{
Zopluoglu C (2022). EstCRM: Calibrating Parameters for the Samejima's Continuous IRT Model. R
package version 1.6, \url{https://CRAN.R-project.org/package=EstCRM}.
}
