% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allFewestLineMap.R
\name{makeAllLineMap}
\alias{makeAllLineMap}
\title{Create an All-line Map}
\usage{
makeAllLineMap(boundsMap, seedX, seedY, verbose = FALSE)
}
\arguments{
\item{boundsMap}{The boundary ShapeMap to create the all-line map in}

\item{seedX}{X coordinate of the seed (the point that initiates the process)}

\item{seedY}{Y coordinate of the seed (the point that initiates the process)}

\item{verbose}{Optional. Show more information of the process.}
}
\value{
An All-line Axial ShapeGraph
}
\description{
Create an All-line Map
}
\examples{
mifFile <- system.file(
    "extdata", "testdata", "simple",
    "simple_interior.mif",
    package = "alcyon"
  )
  sfMap <- st_read(mifFile,
    geometry_column = 1L, quiet = TRUE
  )
  shapeMap <- as(sfMap[, vector()], "ShapeMap")
makeAllLineMap(
  shapeMap,
  seedX = 3.01,
  seedY = 6.7
)
}
