% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unpackaged_utils.R
\name{retrieve_rds}
\alias{retrieve_rds}
\title{Retrieve an R object from the first successful source among multiple attempts}
\usage{
retrieve_rds(..., char_as_url = TRUE)
}
\arguments{
\item{...}{One or more \emph{attempts} to obtain a value. Each attempt may be:
\itemize{
\item a character vector representing the components of a URL to an \code{.rds}
file (e.g., \code{c("https://host", "path", "file.rds")}) when
\code{char_as_url = TRUE}; or
\item any R expression (including a \code{{}} block) that, when evaluated, yields
the desired value.
}

Attempts are tried \strong{in order}. The first one that successfully produces a
value causes an immediate return.}

\item{char_as_url}{logical(1). If \code{TRUE} (default), character attempts are
treated as URL components: they are concatenated with \code{'/'}, opened via
\code{\link[base:connections]{base::url()}}, and read using \code{\link[base:readRDS]{base::readRDS()}}. If \code{FALSE}, character
inputs are not treated specially and will be evaluated as normal R
expressions.}
}
\value{
The first successfully retrieved/produced R object among the
attempts in \code{...}. If none succeed, the function aborts.
}
\description{
\code{retrieve_rds()} tries each argument in \code{...}—in order—until one
successfully yields a value, which is returned immediately. It supports two
kinds of attempts:
\enumerate{
\item \strong{Character input interpreted as a remote RDS URL} (when \code{char_as_url = TRUE}, default):
character vectors are collapsed with \code{'/'}, opened via a URL connection,
and read with \code{readRDS()}.
\item \strong{Arbitrary R expressions/code blocks}: captured unevaluated and then
evaluated in the caller’s environment; the resulting value is returned.
}

If an attempt fail, it tries the next listed attempt. If every attempt fails, the function aborts.
}
\details{
\itemize{
\item \strong{Lazy capture of attempts}: Arguments in \code{...} are captured
unevaluated using \code{\link[rlang:defusing-advanced]{rlang::enexprs()}}, so code blocks passed in braces are
not executed until \code{retrieve_rds()} chooses to evaluate them.
\item \strong{Evaluation environment}: Expressions are evaluated in the caller’s
environment via \code{\link[rlang:eval_tidy]{rlang::eval_tidy()}} with \code{env = rlang::caller_env()},
so symbols resolve exactly as if the code were written at the call site.
\item \strong{Character-as-URL behaviour} (enabled by default):
the character vector is pasted with \code{'/'} separators (no leading/trailing
slash normalization), passed to \code{\link[base:connections]{base::url()}}, then to \code{\link[base:readRDS]{base::readRDS()}}.
Any error during this step is caught and skipped so that the next
attempt can run.
\item \strong{Short-circuiting}: As soon as one attempt succeeds (either by reading an
RDS over HTTP(S) or by evaluating an expression), its value is returned and
no further attempts are processed.
}
}
\section{Error handling}{

\itemize{
\item URL/RDS failures are wrapped in \code{tryCatch()} and \strong{do not} stop the
procedure; the function proceeds to the next attempt.
\item If all attempts fail, the function aborts.
}
}

\examples{
# Example 1: Try a remote RDS first; if it fails, run the code block.
# - With char_as_url = TRUE (default), the character vector is collapsed with "/",
#   opened as a URL, and read via readRDS().
# - If the URL works, the serialized object is returned immediately.
# - If it fails, the code block within curly quotes is evaluated in the
#   caller's environment and its value is returned (here it would assign and
#   return `ale_gam_diamonds`).
serialized_objects_site <- "https://github.com/tripartio/ale/raw/main/download"
retrieve_rds(
  c(serialized_objects_site, "ale_gam_diamonds.0.5.2.rds"),
  {
    ale_gam_diamonds <- "Code for generating an ALE object"
  }
)

# Example 2: First attempt fails as a URL, so the next expression (a literal) is returned.
# - "dodo" is treated as a URL (char_as_url = TRUE), which fails silently.
# - The next attempt (100L) is evaluated and returned.
retrieve_rds(
  "dodo",
  100L
)

# Example 3: Characters are NOT treated as URLs, so the first argument returns immediately.
# - With char_as_url = FALSE, 'dodo' is evaluated as a regular expression (a character)
#   and returned at once; later attempts are ignored.
retrieve_rds(
  'dodo',
  100L,
  char_as_url = FALSE
)

}
\seealso{
\code{\link[base:readRDS]{base::readRDS()}}, \code{\link[base:connections]{base::url()}},
\code{\link[rlang:defusing-advanced]{rlang::enexprs()}}, \code{\link[rlang:eval_tidy]{rlang::eval_tidy()}}, \code{\link[rlang:stack]{rlang::caller_env()}},
\code{\link[cli:cli_abort]{cli::cli_abort()}}
}
