% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/species_to_mfg_df.r
\name{species_to_mfg_df}
\alias{species_to_mfg_df}
\title{Wrapper function to apply species_phyto_convert() across a data.frame}
\usage{
species_to_mfg_df(phyto.df, flag = 1, mfgDbase = NA)
}
\arguments{
\item{phyto.df}{Name of data.frame. Must have character fields named 'genus' and 'species'}

\item{flag}{Resolve ambiguous MFG: 1 = return(NA), 2 = manual selection}

\item{mfgDbase}{specify library of species to MFG associations.}
}
\value{
input data.frame with a new character column of MFG classifications
and diagnostic information
}
\description{
Wrapper function to apply species_phyto_convert() across a data.frame
}
\examples{
data(lakegeneva)
#example dataset with 50 rows

new.lakegeneva <- genus_species_extract(lakegeneva,'phyto_name')
new.lakegeneva <- species_to_mfg_df(new.lakegeneva)
head(new.lakegeneva)
}
