% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/rescale.R
\docType{methods}
\name{rescale_snv}
\alias{rescale_snv}
\alias{rescale_snv-method}
\alias{rescale_snv,numeric,numeric-method}
\alias{rescale_snv,ANY,missing-method}
\title{Standard Normal Variate (SNV) Transformation}
\usage{
rescale_snv(x, y, ...)

\S4method{rescale_snv}{numeric,numeric}(x, y, ...)

\S4method{rescale_snv}{ANY,missing}(x, y, ...)
}
\arguments{
\item{x, y}{A \code{\link{numeric}} vector. If \code{y} is missing, an attempt is made to
interpret \code{x} in a suitable way (see \code{\link[grDevices:xy.coords]{grDevices::xy.coords()}}).}

\item{...}{Currently not used.}
}
\value{
Returns a \code{\link{list}} with two components \code{x} and \code{y}.
}
\description{
Subtracts the mean and scales to unit variance.
}
\examples{
## Raman spectrometry
data("Raman")

## Subset from 200 to 800 1/cm
Raman <- signal_select(Raman, from = 200, to = 800)

## Plot spectrum
plot(Raman, type = "l", xlab = "Raman shift", ylab = "Intensity")

## Normalize SNV
Raman_snv <- rescale_snv(Raman)
plot(Raman_snv, type = "l", xlab = "Raman shift", ylab = "Intensity")
}
\references{
Barnes, R. J., Dhanoa, M. S. & Lister, S. J. (1989). Standard Normal Variate
Transformation and De-Trending of Near-Infrared Diffuse Reflectance Spectra.
\emph{Applied Spectroscopy}, 43(5): 772-777. \doi{10.1366/0003702894202201}.
}
\seealso{
Other normalization methods: 
\code{\link{rescale_area}()},
\code{\link{rescale_range}()},
\code{\link{rescale_total}()},
\code{\link{rescale_transform}()}
}
\author{
N. Frerebeau
}
\concept{normalization methods}
